/* fresnel.cpp */

#include "fp.h"

bool fresnelS(fp& z, fp& x)
{
	fp		arg;
	fp		result, lastResult, term;
	fp		one=1., ten=10.;
	INT32	n;
	bool	precisionGood;
	fp		f, g;
	INT32	p;

	if(abs(x)<=ten)
	{
		p = getBlockPrec();
		//setBlockPrec(p + extra); // extra=125
		setBlockPrec(2*p);
		
		arg = Pi()*x*x/2.;
		arg = arg*arg;
		
		result = lastResult = term = one/3.;
		
		for(n=1;  ;n++)
		{
			term = -term*arg*(one*(4*n-1)/(4*n+3))/(one*2*n*(2*n+1));
			result = result + term;
			if(result==lastResult)
			{
				z = result*Pi()*x*x*x/2;
				setBlockPrec(p);
				return true;
			}
			
			lastResult = result;
		}
	}
	
	// now use asymptotic expansions of f and g
	precisionGood = fresnelF(f, x);
	if(precisionGood)
		precisionGood = fresnelG(g, x);
	else
		fresnelG(g, x);
		
	arg = Pi()*x*x/2.;
	z = .5 - f*cos(arg) - g*sin(arg);
	
	return precisionGood;
	
}/* fresnelS */


bool fresnelC(fp& z, fp& x)
{
	fp		arg;
	fp		result, lastResult, term;
	fp		one=1., ten=10.;
	INT32	n;
	bool	precisionGood; 
	fp		f, g;
	INT32	p;

	if(abs(x)<=ten)
	{
		p = getBlockPrec();
		//setBlockPrec(p + extra); // extra == 125
		setBlockPrec(2*p);
		arg = Pi()*x*x/2.;
		arg = arg*arg;
		
		result = lastResult = term = one;
		
		for(n=1;  ;n++)
		{
			term = -term*arg*(one*(4*n-3)/(4*n+1))/(one*2*n*(2*n-1));
			result = result + term;
			if(result==lastResult)
			{
				z = result*x;
				setBlockPrec(p);
				return true;
			}
			
			lastResult = result;
		}
	}
	
	// now use asymptotic expansions of f and g
	precisionGood = fresnelF(f, x);
	if(precisionGood)
		precisionGood = fresnelG(g, x);
	else
		fresnelG(g, x);
		
	arg = Pi()*x*x/2.;
	z = .5 + f*sin(arg) - g*cos(arg);
	
	return precisionGood;
	
}/* fresnelC */

// the following are asymptotic expansions
bool fresnelF(fp& z, fp& x)
{
	INT32		n;
	fp			f, fLast;
	fp			thisTerm, lastTerm;
	fp			arg;
	bool		precisionGood;
	
	arg = Pi()*x*x;
	arg = arg*arg;
	
	f = fLast = lastTerm = 1.;
	
	for(n=1; ;n++)
	{
		thisTerm = -lastTerm*(4*n-3)*(4*n-1)/arg;
		f = f + thisTerm;
		
		if(f==fLast)
		{
			precisionGood = true;
			break;
		}
		
		if(abs(thisTerm)>abs(lastTerm))
		{
			precisionGood = false;
			break;
		}
		
		lastTerm = thisTerm;
		fLast = f;
	}
	
	z = f/(Pi()*x);
	
	return true;
	
}/* fresnelS */


bool fresnelG(fp& z, fp& x)
{
	INT32		n;
	fp			f, fLast;
	fp			thisTerm, lastTerm;
	fp			arg;
	bool		precisionGood;
	
	arg = Pi()*x*x;
	arg = arg*arg;
	
	f = fLast = lastTerm = 1.;
	
	for(n=1; ;n++)
	{
		thisTerm = -lastTerm*(4*n-1)*(4*n+1)/arg;
		f = f + thisTerm;
		
		if(f==fLast)
		{
			precisionGood = true;
			break;
		}
		
		if(abs(thisTerm)>abs(lastTerm))
		{
			precisionGood = false;
			break;
		}
		
		lastTerm = thisTerm;
		fLast = f;
	}
	
	z = f/(Pi()*Pi()*x*x*x);
	
	return true;
	
}/* fresnelS */
